// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.DelegatedAdminServiceManagementDetailCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Delegated Admin Customer.
 */
public class DelegatedAdminCustomer extends Entity implements IJsonBackedObject {


    /**
     * The Display Name.
     * The Azure AD display name of the customer tenant. Read-only. Supports $orderby.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Tenant Id.
     * The Azure AD-assigned tenant ID of the customer. Read-only.
     */
    @SerializedName(value = "tenantId", alternate = {"TenantId"})
    @Expose
	@Nullable
    public String tenantId;

    /**
     * The Service Management Details.
     * Contains the management details of a service in the customer tenant that's managed by delegated administration.
     */
    @SerializedName(value = "serviceManagementDetails", alternate = {"ServiceManagementDetails"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.DelegatedAdminServiceManagementDetailCollectionPage serviceManagementDetails;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("serviceManagementDetails")) {
            serviceManagementDetails = serializer.deserializeObject(json.get("serviceManagementDetails"), com.microsoft.graph.requests.DelegatedAdminServiceManagementDetailCollectionPage.class);
        }
    }
}
