// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.externalconnectors.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.externalconnectors.models.UrlMatchInfo;
import com.microsoft.graph.externalconnectors.models.UrlToItemResolverBase;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Item Id Resolver.
 */
public class ItemIdResolver extends UrlToItemResolverBase implements IJsonBackedObject {


    /**
     * The Item Id.
     * Pattern that specifies how to form the ID of the external item that the URL represents. The named groups from the regular expression in urlPattern within the urlMatchInfo can be referenced by inserting the group name inside curly brackets.
     */
    @SerializedName(value = "itemId", alternate = {"ItemId"})
    @Expose
	@Nullable
    public String itemId;

    /**
     * The Url Match Info.
     * Configurations to match and resolve URL.
     */
    @SerializedName(value = "urlMatchInfo", alternate = {"UrlMatchInfo"})
    @Expose
	@Nullable
    public UrlMatchInfo urlMatchInfo;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
