// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.callrecords.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Direct Routing Log Row.
 */
public class DirectRoutingLogRow implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Callee Number.
     * Number of the user or bot who received the call. E.164 format, but may include other data.
     */
    @SerializedName(value = "calleeNumber", alternate = {"CalleeNumber"})
    @Expose
	@Nullable
    public String calleeNumber;

    /**
     * The Call End Sub Reason.
     * In addition to the SIP codes, Microsoft has own subcodes that indicate the specific issue.
     */
    @SerializedName(value = "callEndSubReason", alternate = {"CallEndSubReason"})
    @Expose
	@Nullable
    public Integer callEndSubReason;

    /**
     * The Caller Number.
     * Number of the user or bot who made the call. E.164 format, but may include other data.
     */
    @SerializedName(value = "callerNumber", alternate = {"CallerNumber"})
    @Expose
	@Nullable
    public String callerNumber;

    /**
     * The Call Type.
     * Call type and direction.
     */
    @SerializedName(value = "callType", alternate = {"CallType"})
    @Expose
	@Nullable
    public String callType;

    /**
     * The Correlation Id.
     * Identifier for the call that you can use when calling Microsoft Support. GUID.
     */
    @SerializedName(value = "correlationId", alternate = {"CorrelationId"})
    @Expose
	@Nullable
    public String correlationId;

    /**
     * The Duration.
     * Duration of the call in seconds.
     */
    @SerializedName(value = "duration", alternate = {"Duration"})
    @Expose
	@Nullable
    public Integer duration;

    /**
     * The End Date Time.
     * Only exists for successful (fully established) calls. Time when call ended.
     */
    @SerializedName(value = "endDateTime", alternate = {"EndDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime endDateTime;

    /**
     * The Failure Date Time.
     * Only exists for failed (not fully established) calls.
     */
    @SerializedName(value = "failureDateTime", alternate = {"FailureDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime failureDateTime;

    /**
     * The Final Sip Code.
     * The code with which the call ended, see RFC 3261.
     */
    @SerializedName(value = "finalSipCode", alternate = {"FinalSipCode"})
    @Expose
	@Nullable
    public Integer finalSipCode;

    /**
     * The Final Sip Code Phrase.
     * Description of the SIP code and Microsoft subcode.
     */
    @SerializedName(value = "finalSipCodePhrase", alternate = {"FinalSipCodePhrase"})
    @Expose
	@Nullable
    public String finalSipCodePhrase;

    /**
     * The Id.
     * Unique call identifier. GUID.
     */
    @SerializedName(value = "id", alternate = {"Id"})
    @Expose
	@Nullable
    public String id;

    /**
     * The Invite Date Time.
     * When the initial invite was sent.
     */
    @SerializedName(value = "inviteDateTime", alternate = {"InviteDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime inviteDateTime;

    /**
     * The Media Bypass Enabled.
     * Indicates if the trunk was enabled for media bypass or not.
     */
    @SerializedName(value = "mediaBypassEnabled", alternate = {"MediaBypassEnabled"})
    @Expose
	@Nullable
    public Boolean mediaBypassEnabled;

    /**
     * The Media Path Location.
     * The datacenter used for media path in nonbypass call.
     */
    @SerializedName(value = "mediaPathLocation", alternate = {"MediaPathLocation"})
    @Expose
	@Nullable
    public String mediaPathLocation;

    /**
     * The Signaling Location.
     * The datacenter used for signaling for both bypass and nonbypass calls.
     */
    @SerializedName(value = "signalingLocation", alternate = {"SignalingLocation"})
    @Expose
	@Nullable
    public String signalingLocation;

    /**
     * The Start Date Time.
     * Call start time.For failed and unanswered calls, this can be equal to invite or failure time.
     */
    @SerializedName(value = "startDateTime", alternate = {"StartDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime startDateTime;

    /**
     * The Successful Call.
     * Success or attempt.
     */
    @SerializedName(value = "successfulCall", alternate = {"SuccessfulCall"})
    @Expose
	@Nullable
    public Boolean successfulCall;

    /**
     * The Trunk Fully Qualified Domain Name.
     * Fully qualified domain name of the session border controller.
     */
    @SerializedName(value = "trunkFullyQualifiedDomainName", alternate = {"TrunkFullyQualifiedDomainName"})
    @Expose
	@Nullable
    public String trunkFullyQualifiedDomainName;

    /**
     * The User Display Name.
     * Display name of the user.
     */
    @SerializedName(value = "userDisplayName", alternate = {"UserDisplayName"})
    @Expose
	@Nullable
    public String userDisplayName;

    /**
     * The User Id.
     * Calling user's ID in Graph. This and other user info will be null/empty for bot call types. GUID.
     */
    @SerializedName(value = "userId", alternate = {"UserId"})
    @Expose
	@Nullable
    public String userId;

    /**
     * The User Principal Name.
     * UserPrincipalName (sign-in name) in Azure Active Directory. This is usually the same as user's SIP Address, and can be same as user's e-mail address.
     */
    @SerializedName(value = "userPrincipalName", alternate = {"UserPrincipalName"})
    @Expose
	@Nullable
    public String userPrincipalName;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
