// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Vulnerability;
import com.microsoft.graph.security.models.Article;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.ArticleCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.ArticleCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.ArticleCollectionResponse;
import com.microsoft.graph.security.models.Article;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Article Collection With References Page.
 */
public class ArticleCollectionWithReferencesPage extends BaseCollectionPage<Article, ArticleCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for Article
     *
     * @param response the serialized ArticleCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public ArticleCollectionWithReferencesPage(@Nonnull final ArticleCollectionResponse response, @Nullable final ArticleCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for Article
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public ArticleCollectionWithReferencesPage(@Nonnull final java.util.List<Article> pageContents, @Nullable final ArticleCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
