// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ServiceAnnouncement;
import com.microsoft.graph.models.ServiceUpdateMessage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ServiceUpdateMessageCollectionRequestBuilder;
import com.microsoft.graph.requests.ServiceUpdateMessageRequestBuilder;
import com.microsoft.graph.requests.ServiceUpdateMessageCollectionRequest;
import com.microsoft.graph.requests.ServiceUpdateMessageArchiveRequestBuilder;
import com.microsoft.graph.requests.ServiceUpdateMessageFavoriteRequestBuilder;
import com.microsoft.graph.requests.ServiceUpdateMessageMarkReadRequestBuilder;
import com.microsoft.graph.requests.ServiceUpdateMessageMarkUnreadRequestBuilder;
import com.microsoft.graph.requests.ServiceUpdateMessageUnarchiveRequestBuilder;
import com.microsoft.graph.requests.ServiceUpdateMessageUnfavoriteRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.models.ServiceUpdateMessageArchiveParameterSet;
import com.microsoft.graph.models.ServiceUpdateMessageFavoriteParameterSet;
import com.microsoft.graph.models.ServiceUpdateMessageMarkReadParameterSet;
import com.microsoft.graph.models.ServiceUpdateMessageMarkUnreadParameterSet;
import com.microsoft.graph.models.ServiceUpdateMessageUnarchiveParameterSet;
import com.microsoft.graph.models.ServiceUpdateMessageUnfavoriteParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Update Message Collection Request Builder.
 */
public class ServiceUpdateMessageCollectionRequestBuilder extends BaseCollectionRequestBuilder<ServiceUpdateMessage, ServiceUpdateMessageRequestBuilder, ServiceUpdateMessageCollectionResponse, ServiceUpdateMessageCollectionPage, ServiceUpdateMessageCollectionRequest> {

    /**
     * The request builder for this collection of ServiceAnnouncement
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ServiceUpdateMessageCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServiceUpdateMessageRequestBuilder.class, ServiceUpdateMessageCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ServiceUpdateMessageArchiveRequestBuilder archive(@Nonnull final ServiceUpdateMessageArchiveParameterSet parameters) {
        return new ServiceUpdateMessageArchiveRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.archive"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ServiceUpdateMessageFavoriteRequestBuilder favorite(@Nonnull final ServiceUpdateMessageFavoriteParameterSet parameters) {
        return new ServiceUpdateMessageFavoriteRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.favorite"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ServiceUpdateMessageMarkReadRequestBuilder markRead(@Nonnull final ServiceUpdateMessageMarkReadParameterSet parameters) {
        return new ServiceUpdateMessageMarkReadRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.markRead"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ServiceUpdateMessageMarkUnreadRequestBuilder markUnread(@Nonnull final ServiceUpdateMessageMarkUnreadParameterSet parameters) {
        return new ServiceUpdateMessageMarkUnreadRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.markUnread"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ServiceUpdateMessageUnarchiveRequestBuilder unarchive(@Nonnull final ServiceUpdateMessageUnarchiveParameterSet parameters) {
        return new ServiceUpdateMessageUnarchiveRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.unarchive"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ServiceUpdateMessageUnfavoriteRequestBuilder unfavorite(@Nonnull final ServiceUpdateMessageUnfavoriteParameterSet parameters) {
        return new ServiceUpdateMessageUnfavoriteRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.unfavorite"), getClient(), null, parameters);
    }

    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
