// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ColumnDefinition;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Column Definition Request.
 */
public class ColumnDefinitionRequest extends BaseRequest<ColumnDefinition> {
	
    /**
     * The request for the ColumnDefinition
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ColumnDefinitionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ColumnDefinition.class);
    }

    /**
     * Gets the ColumnDefinition from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ColumnDefinition> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ColumnDefinition from the service
     *
     * @return the ColumnDefinition from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ColumnDefinition get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ColumnDefinition> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ColumnDefinition delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ColumnDefinition with a source
     *
     * @param sourceColumnDefinition the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ColumnDefinition> patchAsync(@Nonnull final ColumnDefinition sourceColumnDefinition) {
        return sendAsync(HttpMethod.PATCH, sourceColumnDefinition);
    }

    /**
     * Patches this ColumnDefinition with a source
     *
     * @param sourceColumnDefinition the source object with updates
     * @return the updated ColumnDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ColumnDefinition patch(@Nonnull final ColumnDefinition sourceColumnDefinition) throws ClientException {
        return send(HttpMethod.PATCH, sourceColumnDefinition);
    }

    /**
     * Creates a ColumnDefinition with a new object
     *
     * @param newColumnDefinition the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ColumnDefinition> postAsync(@Nonnull final ColumnDefinition newColumnDefinition) {
        return sendAsync(HttpMethod.POST, newColumnDefinition);
    }

    /**
     * Creates a ColumnDefinition with a new object
     *
     * @param newColumnDefinition the new object to create
     * @return the created ColumnDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ColumnDefinition post(@Nonnull final ColumnDefinition newColumnDefinition) throws ClientException {
        return send(HttpMethod.POST, newColumnDefinition);
    }

    /**
     * Creates a ColumnDefinition with a new object
     *
     * @param newColumnDefinition the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ColumnDefinition> putAsync(@Nonnull final ColumnDefinition newColumnDefinition) {
        return sendAsync(HttpMethod.PUT, newColumnDefinition);
    }

    /**
     * Creates a ColumnDefinition with a new object
     *
     * @param newColumnDefinition the object to create/update
     * @return the created ColumnDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ColumnDefinition put(@Nonnull final ColumnDefinition newColumnDefinition) throws ClientException {
        return send(HttpMethod.PUT, newColumnDefinition);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ColumnDefinitionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ColumnDefinitionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

