// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackage;
import com.microsoft.graph.models.AccessPackageAssignmentRequestRequirements;
import com.microsoft.graph.models.AccessPackageFilterByCurrentUserOptions;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Request.
 */
public class AccessPackageRequest extends BaseRequest<AccessPackage> {
	
    /**
     * The request for the AccessPackage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackage.class);
    }

    /**
     * Gets the AccessPackage from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackage> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessPackage from the service
     *
     * @return the AccessPackage from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackage get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackage> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessPackage delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessPackage with a source
     *
     * @param sourceAccessPackage the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackage> patchAsync(@Nonnull final AccessPackage sourceAccessPackage) {
        return sendAsync(HttpMethod.PATCH, sourceAccessPackage);
    }

    /**
     * Patches this AccessPackage with a source
     *
     * @param sourceAccessPackage the source object with updates
     * @return the updated AccessPackage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackage patch(@Nonnull final AccessPackage sourceAccessPackage) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessPackage);
    }

    /**
     * Creates a AccessPackage with a new object
     *
     * @param newAccessPackage the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackage> postAsync(@Nonnull final AccessPackage newAccessPackage) {
        return sendAsync(HttpMethod.POST, newAccessPackage);
    }

    /**
     * Creates a AccessPackage with a new object
     *
     * @param newAccessPackage the new object to create
     * @return the created AccessPackage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackage post(@Nonnull final AccessPackage newAccessPackage) throws ClientException {
        return send(HttpMethod.POST, newAccessPackage);
    }

    /**
     * Creates a AccessPackage with a new object
     *
     * @param newAccessPackage the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackage> putAsync(@Nonnull final AccessPackage newAccessPackage) {
        return sendAsync(HttpMethod.PUT, newAccessPackage);
    }

    /**
     * Creates a AccessPackage with a new object
     *
     * @param newAccessPackage the object to create/update
     * @return the created AccessPackage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackage put(@Nonnull final AccessPackage newAccessPackage) throws ClientException {
        return send(HttpMethod.PUT, newAccessPackage);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

