/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.BrowserSite;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.BrowserSiteCollectionPage;
import com.microsoft.graph.requests.BrowserSiteCollectionRequestBuilder;
import com.microsoft.graph.requests.BrowserSiteCollectionResponse;
import com.microsoft.graph.requests.BrowserSiteRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BrowserSiteCollectionRequest
extends BaseEntityCollectionRequest<BrowserSite, BrowserSiteCollectionResponse, BrowserSiteCollectionPage> {
    public BrowserSiteCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BrowserSiteCollectionResponse.class, BrowserSiteCollectionPage.class, BrowserSiteCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<BrowserSite> postAsync(@Nonnull BrowserSite newBrowserSite) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new BrowserSiteRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newBrowserSite);
    }

    @Nonnull
    public BrowserSite post(@Nonnull BrowserSite newBrowserSite) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new BrowserSiteRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newBrowserSite);
    }

    @Nonnull
    public BrowserSiteCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public BrowserSiteCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public BrowserSiteCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public BrowserSiteCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public BrowserSiteCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public BrowserSiteCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public BrowserSiteCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public BrowserSiteCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public BrowserSiteCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

