/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.Synchronization;
import com.microsoft.graph.models.SynchronizationAcquireAccessTokenParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.SynchronizationAcquireAccessTokenRequestBuilder;
import com.microsoft.graph.requests.SynchronizationJobCollectionRequestBuilder;
import com.microsoft.graph.requests.SynchronizationJobRequestBuilder;
import com.microsoft.graph.requests.SynchronizationRequest;
import com.microsoft.graph.requests.SynchronizationTemplateCollectionRequestBuilder;
import com.microsoft.graph.requests.SynchronizationTemplateRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SynchronizationRequestBuilder
extends BaseRequestBuilder<Synchronization> {
    public SynchronizationRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public SynchronizationRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public SynchronizationRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new SynchronizationRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public SynchronizationJobCollectionRequestBuilder jobs() {
        return new SynchronizationJobCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("jobs"), this.getClient(), null);
    }

    @Nonnull
    public SynchronizationJobRequestBuilder jobs(@Nonnull String id) {
        return new SynchronizationJobRequestBuilder(this.getRequestUrlWithAdditionalSegment("jobs") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public SynchronizationTemplateCollectionRequestBuilder templates() {
        return new SynchronizationTemplateCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("templates"), this.getClient(), null);
    }

    @Nonnull
    public SynchronizationTemplateRequestBuilder templates(@Nonnull String id) {
        return new SynchronizationTemplateRequestBuilder(this.getRequestUrlWithAdditionalSegment("templates") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public SynchronizationAcquireAccessTokenRequestBuilder acquireAccessToken(@Nonnull SynchronizationAcquireAccessTokenParameterSet parameters) {
        return new SynchronizationAcquireAccessTokenRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.acquireAccessToken"), this.getClient(), null, parameters);
    }
}

