/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Person;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PersonRequest
extends BaseRequest<Person> {
    public PersonRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Person.class);
    }

    @Nonnull
    public CompletableFuture<Person> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Person get() throws ClientException {
        return (Person)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Person> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Person delete() throws ClientException {
        return (Person)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Person> patchAsync(@Nonnull Person sourcePerson) {
        return this.sendAsync(HttpMethod.PATCH, sourcePerson);
    }

    @Nullable
    public Person patch(@Nonnull Person sourcePerson) throws ClientException {
        return (Person)this.send(HttpMethod.PATCH, sourcePerson);
    }

    @Nonnull
    public CompletableFuture<Person> postAsync(@Nonnull Person newPerson) {
        return this.sendAsync(HttpMethod.POST, newPerson);
    }

    @Nullable
    public Person post(@Nonnull Person newPerson) throws ClientException {
        return (Person)this.send(HttpMethod.POST, newPerson);
    }

    @Nonnull
    public CompletableFuture<Person> putAsync(@Nonnull Person newPerson) {
        return this.sendAsync(HttpMethod.PUT, newPerson);
    }

    @Nullable
    public Person put(@Nonnull Person newPerson) throws ClientException {
        return (Person)this.send(HttpMethod.PUT, newPerson);
    }

    @Nonnull
    public PersonRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PersonRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

