// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UnifiedRoleManagementPolicyAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Management Policy Assignment Request.
 */
public class UnifiedRoleManagementPolicyAssignmentRequest extends BaseRequest<UnifiedRoleManagementPolicyAssignment> {
	
    /**
     * The request for the UnifiedRoleManagementPolicyAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRoleManagementPolicyAssignmentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnifiedRoleManagementPolicyAssignment.class);
    }

    /**
     * Gets the UnifiedRoleManagementPolicyAssignment from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyAssignment> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UnifiedRoleManagementPolicyAssignment from the service
     *
     * @return the UnifiedRoleManagementPolicyAssignment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyAssignment get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyAssignment> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UnifiedRoleManagementPolicyAssignment delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UnifiedRoleManagementPolicyAssignment with a source
     *
     * @param sourceUnifiedRoleManagementPolicyAssignment the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyAssignment> patchAsync(@Nonnull final UnifiedRoleManagementPolicyAssignment sourceUnifiedRoleManagementPolicyAssignment) {
        return sendAsync(HttpMethod.PATCH, sourceUnifiedRoleManagementPolicyAssignment);
    }

    /**
     * Patches this UnifiedRoleManagementPolicyAssignment with a source
     *
     * @param sourceUnifiedRoleManagementPolicyAssignment the source object with updates
     * @return the updated UnifiedRoleManagementPolicyAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyAssignment patch(@Nonnull final UnifiedRoleManagementPolicyAssignment sourceUnifiedRoleManagementPolicyAssignment) throws ClientException {
        return send(HttpMethod.PATCH, sourceUnifiedRoleManagementPolicyAssignment);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyAssignment with a new object
     *
     * @param newUnifiedRoleManagementPolicyAssignment the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyAssignment> postAsync(@Nonnull final UnifiedRoleManagementPolicyAssignment newUnifiedRoleManagementPolicyAssignment) {
        return sendAsync(HttpMethod.POST, newUnifiedRoleManagementPolicyAssignment);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyAssignment with a new object
     *
     * @param newUnifiedRoleManagementPolicyAssignment the new object to create
     * @return the created UnifiedRoleManagementPolicyAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyAssignment post(@Nonnull final UnifiedRoleManagementPolicyAssignment newUnifiedRoleManagementPolicyAssignment) throws ClientException {
        return send(HttpMethod.POST, newUnifiedRoleManagementPolicyAssignment);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyAssignment with a new object
     *
     * @param newUnifiedRoleManagementPolicyAssignment the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyAssignment> putAsync(@Nonnull final UnifiedRoleManagementPolicyAssignment newUnifiedRoleManagementPolicyAssignment) {
        return sendAsync(HttpMethod.PUT, newUnifiedRoleManagementPolicyAssignment);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyAssignment with a new object
     *
     * @param newUnifiedRoleManagementPolicyAssignment the object to create/update
     * @return the created UnifiedRoleManagementPolicyAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyAssignment put(@Nonnull final UnifiedRoleManagementPolicyAssignment newUnifiedRoleManagementPolicyAssignment) throws ClientException {
        return send(HttpMethod.PUT, newUnifiedRoleManagementPolicyAssignment);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRoleManagementPolicyAssignmentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRoleManagementPolicyAssignmentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

