// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleRequestCancelRequest;
import com.microsoft.graph.models.UnifiedRoleEligibilityScheduleRequest;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Eligibility Schedule Request Cancel Request Builder.
 */
public class UnifiedRoleEligibilityScheduleRequestCancelRequestBuilder extends BaseActionRequestBuilder<UnifiedRoleEligibilityScheduleRequest> {

    /**
     * The request builder for this UnifiedRoleEligibilityScheduleRequestCancel
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRoleEligibilityScheduleRequestCancelRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the UnifiedRoleEligibilityScheduleRequestCancelRequest
     *
     * @param requestOptions the options for the request
     * @return the UnifiedRoleEligibilityScheduleRequestCancelRequest instance
     */
    @Nonnull
    public UnifiedRoleEligibilityScheduleRequestCancelRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the UnifiedRoleEligibilityScheduleRequestCancelRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the UnifiedRoleEligibilityScheduleRequestCancelRequest instance
     */
    @Nonnull
    public UnifiedRoleEligibilityScheduleRequestCancelRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final UnifiedRoleEligibilityScheduleRequestCancelRequest request = new UnifiedRoleEligibilityScheduleRequestCancelRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
