// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ParticipantJoiningNotification;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Participant Joining Notification Request.
 */
public class ParticipantJoiningNotificationRequest extends BaseRequest<ParticipantJoiningNotification> {
	
    /**
     * The request for the ParticipantJoiningNotification
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ParticipantJoiningNotificationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ParticipantJoiningNotification.class);
    }

    /**
     * Gets the ParticipantJoiningNotification from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ParticipantJoiningNotification> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ParticipantJoiningNotification from the service
     *
     * @return the ParticipantJoiningNotification from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ParticipantJoiningNotification get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ParticipantJoiningNotification> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ParticipantJoiningNotification delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ParticipantJoiningNotification with a source
     *
     * @param sourceParticipantJoiningNotification the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ParticipantJoiningNotification> patchAsync(@Nonnull final ParticipantJoiningNotification sourceParticipantJoiningNotification) {
        return sendAsync(HttpMethod.PATCH, sourceParticipantJoiningNotification);
    }

    /**
     * Patches this ParticipantJoiningNotification with a source
     *
     * @param sourceParticipantJoiningNotification the source object with updates
     * @return the updated ParticipantJoiningNotification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ParticipantJoiningNotification patch(@Nonnull final ParticipantJoiningNotification sourceParticipantJoiningNotification) throws ClientException {
        return send(HttpMethod.PATCH, sourceParticipantJoiningNotification);
    }

    /**
     * Creates a ParticipantJoiningNotification with a new object
     *
     * @param newParticipantJoiningNotification the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ParticipantJoiningNotification> postAsync(@Nonnull final ParticipantJoiningNotification newParticipantJoiningNotification) {
        return sendAsync(HttpMethod.POST, newParticipantJoiningNotification);
    }

    /**
     * Creates a ParticipantJoiningNotification with a new object
     *
     * @param newParticipantJoiningNotification the new object to create
     * @return the created ParticipantJoiningNotification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ParticipantJoiningNotification post(@Nonnull final ParticipantJoiningNotification newParticipantJoiningNotification) throws ClientException {
        return send(HttpMethod.POST, newParticipantJoiningNotification);
    }

    /**
     * Creates a ParticipantJoiningNotification with a new object
     *
     * @param newParticipantJoiningNotification the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ParticipantJoiningNotification> putAsync(@Nonnull final ParticipantJoiningNotification newParticipantJoiningNotification) {
        return sendAsync(HttpMethod.PUT, newParticipantJoiningNotification);
    }

    /**
     * Creates a ParticipantJoiningNotification with a new object
     *
     * @param newParticipantJoiningNotification the object to create/update
     * @return the created ParticipantJoiningNotification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ParticipantJoiningNotification put(@Nonnull final ParticipantJoiningNotification newParticipantJoiningNotification) throws ClientException {
        return send(HttpMethod.PUT, newParticipantJoiningNotification);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ParticipantJoiningNotificationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ParticipantJoiningNotificationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

