// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DocumentSetVersion;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Document Set Version Request.
 */
public class DocumentSetVersionRequest extends BaseRequest<DocumentSetVersion> {
	
    /**
     * The request for the DocumentSetVersion
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DocumentSetVersionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DocumentSetVersion.class);
    }

    /**
     * Gets the DocumentSetVersion from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DocumentSetVersion> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DocumentSetVersion from the service
     *
     * @return the DocumentSetVersion from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DocumentSetVersion get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DocumentSetVersion> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DocumentSetVersion delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DocumentSetVersion with a source
     *
     * @param sourceDocumentSetVersion the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DocumentSetVersion> patchAsync(@Nonnull final DocumentSetVersion sourceDocumentSetVersion) {
        return sendAsync(HttpMethod.PATCH, sourceDocumentSetVersion);
    }

    /**
     * Patches this DocumentSetVersion with a source
     *
     * @param sourceDocumentSetVersion the source object with updates
     * @return the updated DocumentSetVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DocumentSetVersion patch(@Nonnull final DocumentSetVersion sourceDocumentSetVersion) throws ClientException {
        return send(HttpMethod.PATCH, sourceDocumentSetVersion);
    }

    /**
     * Creates a DocumentSetVersion with a new object
     *
     * @param newDocumentSetVersion the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DocumentSetVersion> postAsync(@Nonnull final DocumentSetVersion newDocumentSetVersion) {
        return sendAsync(HttpMethod.POST, newDocumentSetVersion);
    }

    /**
     * Creates a DocumentSetVersion with a new object
     *
     * @param newDocumentSetVersion the new object to create
     * @return the created DocumentSetVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DocumentSetVersion post(@Nonnull final DocumentSetVersion newDocumentSetVersion) throws ClientException {
        return send(HttpMethod.POST, newDocumentSetVersion);
    }

    /**
     * Creates a DocumentSetVersion with a new object
     *
     * @param newDocumentSetVersion the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DocumentSetVersion> putAsync(@Nonnull final DocumentSetVersion newDocumentSetVersion) {
        return sendAsync(HttpMethod.PUT, newDocumentSetVersion);
    }

    /**
     * Creates a DocumentSetVersion with a new object
     *
     * @param newDocumentSetVersion the object to create/update
     * @return the created DocumentSetVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DocumentSetVersion put(@Nonnull final DocumentSetVersion newDocumentSetVersion) throws ClientException {
        return send(HttpMethod.PUT, newDocumentSetVersion);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DocumentSetVersionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DocumentSetVersionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

