/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.ediscovery.models.DataSource;
import com.microsoft.graph.ediscovery.requests.DataSourceCollectionPage;
import com.microsoft.graph.ediscovery.requests.DataSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.DataSourceCollectionResponse;
import com.microsoft.graph.ediscovery.requests.DataSourceRequestBuilder;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataSourceCollectionRequest
extends BaseEntityCollectionRequest<DataSource, DataSourceCollectionResponse, DataSourceCollectionPage> {
    public DataSourceCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DataSourceCollectionResponse.class, DataSourceCollectionPage.class, DataSourceCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<DataSource> postAsync(@Nonnull DataSource newDataSource) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DataSourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newDataSource);
    }

    @Nonnull
    public DataSource post(@Nonnull DataSource newDataSource) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DataSourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDataSource);
    }

    @Nonnull
    public DataSourceCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public DataSourceCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public DataSourceCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public DataSourceCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DataSourceCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public DataSourceCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public DataSourceCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public DataSourceCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public DataSourceCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

