// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookRangeFont;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Range Font Request.
 */
public class WorkbookRangeFontRequest extends BaseRequest<WorkbookRangeFont> {
	
    /**
     * The request for the WorkbookRangeFont
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookRangeFontRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookRangeFont.class);
    }

    /**
     * Gets the WorkbookRangeFont from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeFont> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookRangeFont from the service
     *
     * @return the WorkbookRangeFont from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeFont get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeFont> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookRangeFont delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookRangeFont with a source
     *
     * @param sourceWorkbookRangeFont the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeFont> patchAsync(@Nonnull final WorkbookRangeFont sourceWorkbookRangeFont) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookRangeFont);
    }

    /**
     * Patches this WorkbookRangeFont with a source
     *
     * @param sourceWorkbookRangeFont the source object with updates
     * @return the updated WorkbookRangeFont
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeFont patch(@Nonnull final WorkbookRangeFont sourceWorkbookRangeFont) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookRangeFont);
    }

    /**
     * Creates a WorkbookRangeFont with a new object
     *
     * @param newWorkbookRangeFont the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeFont> postAsync(@Nonnull final WorkbookRangeFont newWorkbookRangeFont) {
        return sendAsync(HttpMethod.POST, newWorkbookRangeFont);
    }

    /**
     * Creates a WorkbookRangeFont with a new object
     *
     * @param newWorkbookRangeFont the new object to create
     * @return the created WorkbookRangeFont
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeFont post(@Nonnull final WorkbookRangeFont newWorkbookRangeFont) throws ClientException {
        return send(HttpMethod.POST, newWorkbookRangeFont);
    }

    /**
     * Creates a WorkbookRangeFont with a new object
     *
     * @param newWorkbookRangeFont the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeFont> putAsync(@Nonnull final WorkbookRangeFont newWorkbookRangeFont) {
        return sendAsync(HttpMethod.PUT, newWorkbookRangeFont);
    }

    /**
     * Creates a WorkbookRangeFont with a new object
     *
     * @param newWorkbookRangeFont the object to create/update
     * @return the created WorkbookRangeFont
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeFont put(@Nonnull final WorkbookRangeFont newWorkbookRangeFont) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookRangeFont);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookRangeFontRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookRangeFontRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

