// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Compliance;
import com.microsoft.graph.ediscovery.requests.EdiscoveryrootRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Compliance Request.
 */
public class ComplianceRequest extends BaseRequest<Compliance> {
	
    /**
     * The request for the Compliance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ComplianceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Compliance.class);
    }

    /**
     * Gets the Compliance from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Compliance> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Compliance from the service
     *
     * @return the Compliance from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Compliance get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Compliance> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Compliance delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Compliance with a source
     *
     * @param sourceCompliance the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Compliance> patchAsync(@Nonnull final Compliance sourceCompliance) {
        return sendAsync(HttpMethod.PATCH, sourceCompliance);
    }

    /**
     * Patches this Compliance with a source
     *
     * @param sourceCompliance the source object with updates
     * @return the updated Compliance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Compliance patch(@Nonnull final Compliance sourceCompliance) throws ClientException {
        return send(HttpMethod.PATCH, sourceCompliance);
    }

    /**
     * Creates a Compliance with a new object
     *
     * @param newCompliance the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Compliance> postAsync(@Nonnull final Compliance newCompliance) {
        return sendAsync(HttpMethod.POST, newCompliance);
    }

    /**
     * Creates a Compliance with a new object
     *
     * @param newCompliance the new object to create
     * @return the created Compliance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Compliance post(@Nonnull final Compliance newCompliance) throws ClientException {
        return send(HttpMethod.POST, newCompliance);
    }

    /**
     * Creates a Compliance with a new object
     *
     * @param newCompliance the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Compliance> putAsync(@Nonnull final Compliance newCompliance) {
        return sendAsync(HttpMethod.PUT, newCompliance);
    }

    /**
     * Creates a Compliance with a new object
     *
     * @param newCompliance the object to create/update
     * @return the created Compliance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Compliance put(@Nonnull final Compliance newCompliance) throws ClientException {
        return send(HttpMethod.PUT, newCompliance);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ComplianceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ComplianceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

