// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.Tag;
import com.microsoft.graph.ediscovery.requests.TagCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.ediscovery.requests.TagWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Tag Request.
 */
public class TagRequest extends BaseRequest<Tag> {
	
    /**
     * The request for the Tag
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TagRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Tag.class);
    }

    /**
     * Gets the Tag from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Tag> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Tag from the service
     *
     * @return the Tag from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Tag get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Tag> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Tag delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Tag with a source
     *
     * @param sourceTag the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Tag> patchAsync(@Nonnull final Tag sourceTag) {
        return sendAsync(HttpMethod.PATCH, sourceTag);
    }

    /**
     * Patches this Tag with a source
     *
     * @param sourceTag the source object with updates
     * @return the updated Tag
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Tag patch(@Nonnull final Tag sourceTag) throws ClientException {
        return send(HttpMethod.PATCH, sourceTag);
    }

    /**
     * Creates a Tag with a new object
     *
     * @param newTag the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Tag> postAsync(@Nonnull final Tag newTag) {
        return sendAsync(HttpMethod.POST, newTag);
    }

    /**
     * Creates a Tag with a new object
     *
     * @param newTag the new object to create
     * @return the created Tag
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Tag post(@Nonnull final Tag newTag) throws ClientException {
        return send(HttpMethod.POST, newTag);
    }

    /**
     * Creates a Tag with a new object
     *
     * @param newTag the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Tag> putAsync(@Nonnull final Tag newTag) {
        return sendAsync(HttpMethod.PUT, newTag);
    }

    /**
     * Creates a Tag with a new object
     *
     * @param newTag the object to create/update
     * @return the created Tag
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Tag put(@Nonnull final Tag newTag) throws ClientException {
        return send(HttpMethod.PUT, newTag);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TagRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TagRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

