// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.TagOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Tag Operation Request.
 */
public class TagOperationRequest extends BaseRequest<TagOperation> {
	
    /**
     * The request for the TagOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TagOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TagOperation.class);
    }

    /**
     * Gets the TagOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TagOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TagOperation from the service
     *
     * @return the TagOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TagOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TagOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TagOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TagOperation with a source
     *
     * @param sourceTagOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TagOperation> patchAsync(@Nonnull final TagOperation sourceTagOperation) {
        return sendAsync(HttpMethod.PATCH, sourceTagOperation);
    }

    /**
     * Patches this TagOperation with a source
     *
     * @param sourceTagOperation the source object with updates
     * @return the updated TagOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TagOperation patch(@Nonnull final TagOperation sourceTagOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceTagOperation);
    }

    /**
     * Creates a TagOperation with a new object
     *
     * @param newTagOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TagOperation> postAsync(@Nonnull final TagOperation newTagOperation) {
        return sendAsync(HttpMethod.POST, newTagOperation);
    }

    /**
     * Creates a TagOperation with a new object
     *
     * @param newTagOperation the new object to create
     * @return the created TagOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TagOperation post(@Nonnull final TagOperation newTagOperation) throws ClientException {
        return send(HttpMethod.POST, newTagOperation);
    }

    /**
     * Creates a TagOperation with a new object
     *
     * @param newTagOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TagOperation> putAsync(@Nonnull final TagOperation newTagOperation) {
        return sendAsync(HttpMethod.PUT, newTagOperation);
    }

    /**
     * Creates a TagOperation with a new object
     *
     * @param newTagOperation the object to create/update
     * @return the created TagOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TagOperation put(@Nonnull final TagOperation newTagOperation) throws ClientException {
        return send(HttpMethod.PUT, newTagOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TagOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TagOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

