// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.ReviewSet;
import com.microsoft.graph.ediscovery.requests.ReviewSetQueryCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.ReviewSetQueryRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Review Set Request.
 */
public class ReviewSetRequest extends BaseRequest<ReviewSet> {
	
    /**
     * The request for the ReviewSet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ReviewSetRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ReviewSet.class);
    }

    /**
     * Gets the ReviewSet from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ReviewSet> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ReviewSet from the service
     *
     * @return the ReviewSet from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ReviewSet get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ReviewSet> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ReviewSet delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ReviewSet with a source
     *
     * @param sourceReviewSet the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ReviewSet> patchAsync(@Nonnull final ReviewSet sourceReviewSet) {
        return sendAsync(HttpMethod.PATCH, sourceReviewSet);
    }

    /**
     * Patches this ReviewSet with a source
     *
     * @param sourceReviewSet the source object with updates
     * @return the updated ReviewSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ReviewSet patch(@Nonnull final ReviewSet sourceReviewSet) throws ClientException {
        return send(HttpMethod.PATCH, sourceReviewSet);
    }

    /**
     * Creates a ReviewSet with a new object
     *
     * @param newReviewSet the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ReviewSet> postAsync(@Nonnull final ReviewSet newReviewSet) {
        return sendAsync(HttpMethod.POST, newReviewSet);
    }

    /**
     * Creates a ReviewSet with a new object
     *
     * @param newReviewSet the new object to create
     * @return the created ReviewSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ReviewSet post(@Nonnull final ReviewSet newReviewSet) throws ClientException {
        return send(HttpMethod.POST, newReviewSet);
    }

    /**
     * Creates a ReviewSet with a new object
     *
     * @param newReviewSet the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ReviewSet> putAsync(@Nonnull final ReviewSet newReviewSet) {
        return sendAsync(HttpMethod.PUT, newReviewSet);
    }

    /**
     * Creates a ReviewSet with a new object
     *
     * @param newReviewSet the object to create/update
     * @return the created ReviewSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ReviewSet put(@Nonnull final ReviewSet newReviewSet) throws ClientException {
        return send(HttpMethod.PUT, newReviewSet);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ReviewSetRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ReviewSetRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

