// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.ReviewSetQuery;
import com.microsoft.graph.ediscovery.models.Tag;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Review Set Query Request.
 */
public class ReviewSetQueryRequest extends BaseRequest<ReviewSetQuery> {
	
    /**
     * The request for the ReviewSetQuery
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ReviewSetQueryRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ReviewSetQuery.class);
    }

    /**
     * Gets the ReviewSetQuery from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ReviewSetQuery> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ReviewSetQuery from the service
     *
     * @return the ReviewSetQuery from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ReviewSetQuery get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ReviewSetQuery> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ReviewSetQuery delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ReviewSetQuery with a source
     *
     * @param sourceReviewSetQuery the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ReviewSetQuery> patchAsync(@Nonnull final ReviewSetQuery sourceReviewSetQuery) {
        return sendAsync(HttpMethod.PATCH, sourceReviewSetQuery);
    }

    /**
     * Patches this ReviewSetQuery with a source
     *
     * @param sourceReviewSetQuery the source object with updates
     * @return the updated ReviewSetQuery
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ReviewSetQuery patch(@Nonnull final ReviewSetQuery sourceReviewSetQuery) throws ClientException {
        return send(HttpMethod.PATCH, sourceReviewSetQuery);
    }

    /**
     * Creates a ReviewSetQuery with a new object
     *
     * @param newReviewSetQuery the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ReviewSetQuery> postAsync(@Nonnull final ReviewSetQuery newReviewSetQuery) {
        return sendAsync(HttpMethod.POST, newReviewSetQuery);
    }

    /**
     * Creates a ReviewSetQuery with a new object
     *
     * @param newReviewSetQuery the new object to create
     * @return the created ReviewSetQuery
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ReviewSetQuery post(@Nonnull final ReviewSetQuery newReviewSetQuery) throws ClientException {
        return send(HttpMethod.POST, newReviewSetQuery);
    }

    /**
     * Creates a ReviewSetQuery with a new object
     *
     * @param newReviewSetQuery the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ReviewSetQuery> putAsync(@Nonnull final ReviewSetQuery newReviewSetQuery) {
        return sendAsync(HttpMethod.PUT, newReviewSetQuery);
    }

    /**
     * Creates a ReviewSetQuery with a new object
     *
     * @param newReviewSetQuery the object to create/update
     * @return the created ReviewSetQuery
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ReviewSetQuery put(@Nonnull final ReviewSetQuery newReviewSetQuery) throws ClientException {
        return send(HttpMethod.PUT, newReviewSetQuery);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ReviewSetQueryRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ReviewSetQueryRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

