// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;
import com.microsoft.graph.ediscovery.requests.NoncustodialDataSourceUpdateIndexRequest;
import com.microsoft.graph.ediscovery.models.NoncustodialDataSource;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Noncustodial Data Source Update Index Request Builder.
 */
public class NoncustodialDataSourceUpdateIndexRequestBuilder extends BaseActionRequestBuilder<NoncustodialDataSource> {

    /**
     * The request builder for this NoncustodialDataSourceUpdateIndex
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public NoncustodialDataSourceUpdateIndexRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the NoncustodialDataSourceUpdateIndexRequest
     *
     * @param requestOptions the options for the request
     * @return the NoncustodialDataSourceUpdateIndexRequest instance
     */
    @Nonnull
    public NoncustodialDataSourceUpdateIndexRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the NoncustodialDataSourceUpdateIndexRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the NoncustodialDataSourceUpdateIndexRequest instance
     */
    @Nonnull
    public NoncustodialDataSourceUpdateIndexRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final NoncustodialDataSourceUpdateIndexRequest request = new NoncustodialDataSourceUpdateIndexRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
