// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.Ediscoveryroot;
import com.microsoft.graph.ediscovery.requests.CaseCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.CaseRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscoveryroot Request.
 */
public class EdiscoveryrootRequest extends BaseRequest<Ediscoveryroot> {
	
    /**
     * The request for the Ediscoveryroot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryrootRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Ediscoveryroot.class);
    }

    /**
     * Gets the Ediscoveryroot from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Ediscoveryroot> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Ediscoveryroot from the service
     *
     * @return the Ediscoveryroot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Ediscoveryroot get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Ediscoveryroot> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Ediscoveryroot delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Ediscoveryroot with a source
     *
     * @param sourceEdiscoveryroot the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Ediscoveryroot> patchAsync(@Nonnull final Ediscoveryroot sourceEdiscoveryroot) {
        return sendAsync(HttpMethod.PATCH, sourceEdiscoveryroot);
    }

    /**
     * Patches this Ediscoveryroot with a source
     *
     * @param sourceEdiscoveryroot the source object with updates
     * @return the updated Ediscoveryroot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Ediscoveryroot patch(@Nonnull final Ediscoveryroot sourceEdiscoveryroot) throws ClientException {
        return send(HttpMethod.PATCH, sourceEdiscoveryroot);
    }

    /**
     * Creates a Ediscoveryroot with a new object
     *
     * @param newEdiscoveryroot the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Ediscoveryroot> postAsync(@Nonnull final Ediscoveryroot newEdiscoveryroot) {
        return sendAsync(HttpMethod.POST, newEdiscoveryroot);
    }

    /**
     * Creates a Ediscoveryroot with a new object
     *
     * @param newEdiscoveryroot the new object to create
     * @return the created Ediscoveryroot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Ediscoveryroot post(@Nonnull final Ediscoveryroot newEdiscoveryroot) throws ClientException {
        return send(HttpMethod.POST, newEdiscoveryroot);
    }

    /**
     * Creates a Ediscoveryroot with a new object
     *
     * @param newEdiscoveryroot the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Ediscoveryroot> putAsync(@Nonnull final Ediscoveryroot newEdiscoveryroot) {
        return sendAsync(HttpMethod.PUT, newEdiscoveryroot);
    }

    /**
     * Creates a Ediscoveryroot with a new object
     *
     * @param newEdiscoveryroot the object to create/update
     * @return the created Ediscoveryroot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Ediscoveryroot put(@Nonnull final Ediscoveryroot newEdiscoveryroot) throws ClientException {
        return send(HttpMethod.PUT, newEdiscoveryroot);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryrootRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryrootRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

