// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.Custodian;
import com.microsoft.graph.ediscovery.requests.SiteSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.SiteSourceRequestBuilder;
import com.microsoft.graph.ediscovery.requests.UnifiedGroupSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.UnifiedGroupSourceRequestBuilder;
import com.microsoft.graph.ediscovery.requests.UserSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.UserSourceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Custodian Request.
 */
public class CustodianRequest extends BaseRequest<Custodian> {
	
    /**
     * The request for the Custodian
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CustodianRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Custodian.class);
    }

    /**
     * Gets the Custodian from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Custodian> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Custodian from the service
     *
     * @return the Custodian from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Custodian get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Custodian> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Custodian delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Custodian with a source
     *
     * @param sourceCustodian the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Custodian> patchAsync(@Nonnull final Custodian sourceCustodian) {
        return sendAsync(HttpMethod.PATCH, sourceCustodian);
    }

    /**
     * Patches this Custodian with a source
     *
     * @param sourceCustodian the source object with updates
     * @return the updated Custodian
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Custodian patch(@Nonnull final Custodian sourceCustodian) throws ClientException {
        return send(HttpMethod.PATCH, sourceCustodian);
    }

    /**
     * Creates a Custodian with a new object
     *
     * @param newCustodian the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Custodian> postAsync(@Nonnull final Custodian newCustodian) {
        return sendAsync(HttpMethod.POST, newCustodian);
    }

    /**
     * Creates a Custodian with a new object
     *
     * @param newCustodian the new object to create
     * @return the created Custodian
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Custodian post(@Nonnull final Custodian newCustodian) throws ClientException {
        return send(HttpMethod.POST, newCustodian);
    }

    /**
     * Creates a Custodian with a new object
     *
     * @param newCustodian the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Custodian> putAsync(@Nonnull final Custodian newCustodian) {
        return sendAsync(HttpMethod.PUT, newCustodian);
    }

    /**
     * Creates a Custodian with a new object
     *
     * @param newCustodian the object to create/update
     * @return the created Custodian
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Custodian put(@Nonnull final Custodian newCustodian) throws ClientException {
        return send(HttpMethod.PUT, newCustodian);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CustodianRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CustodianRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

