// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.ediscovery.models.ChildSelectability;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.ediscovery.models.Tag;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.ediscovery.requests.TagCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Tag.
 */
public class Tag extends Entity implements IJsonBackedObject {


    /**
     * The Child Selectability.
     * Indicates whether a single or multiple child tags can be associated with a document. Possible values are: One, Many.  This value controls whether the UX presents the tags as checkboxes or a radio button group.
     */
    @SerializedName(value = "childSelectability", alternate = {"ChildSelectability"})
    @Expose
	@Nullable
    public ChildSelectability childSelectability;

    /**
     * The Created By.
     * The user who created the tag.
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
	@Nullable
    public IdentitySet createdBy;

    /**
     * The Description.
     * The description for the tag.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * Display name of the tag.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Last Modified Date Time.
     * The date and time the tag was last modified.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Child Tags.
     * Returns the tags that are a child of a tag.
     */
	@Nullable
    public TagCollectionPage childTags;

    /**
     * The Parent.
     * Returns the parent tag of the specified tag.
     */
    @SerializedName(value = "parent", alternate = {"Parent"})
    @Expose
	@Nullable
    public Tag parent;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("childTags")) {
            childTags = serializer.deserializeObject(json.get("childTags"), TagCollectionPage.class);
        }
    }
}
