// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.VmCloudProvider;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Vm Metadata.
 */
public class VmMetadata implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Cloud Provider.
     * The cloud provider hosting the virtual machine. The possible values are: unknown, azure, unknownFutureValue.
     */
    @SerializedName(value = "cloudProvider", alternate = {"CloudProvider"})
    @Expose
	@Nullable
    public VmCloudProvider cloudProvider;

    /**
     * The Resource Id.
     * Unique identifier of the Azure resource.
     */
    @SerializedName(value = "resourceId", alternate = {"ResourceId"})
    @Expose
	@Nullable
    public String resourceId;

    /**
     * The Subscription Id.
     * Unique identifier of the Azure subscription the customer tenant belongs to.
     */
    @SerializedName(value = "subscriptionId", alternate = {"SubscriptionId"})
    @Expose
	@Nullable
    public String subscriptionId;

    /**
     * The Vm Id.
     * Unique identifier of the virtual machine instance.
     */
    @SerializedName(value = "vmId", alternate = {"VmId"})
    @Expose
	@Nullable
    public String vmId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
