// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.B2xIdentityUserFlow;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the B2x Identity User Flow Request Builder.
 */
public class B2xIdentityUserFlowRequestBuilder extends BaseRequestBuilder<B2xIdentityUserFlow> {

    /**
     * The request builder for the B2xIdentityUserFlow
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public B2xIdentityUserFlowRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the B2xIdentityUserFlowRequest instance
     */
    @Nonnull
    public B2xIdentityUserFlowRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the B2xIdentityUserFlowRequest instance
     */
    @Nonnull
    public B2xIdentityUserFlowRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.B2xIdentityUserFlowRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the IdentityProvider collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.IdentityProviderCollectionWithReferencesRequestBuilder identityProviders() {
        return new com.microsoft.graph.requests.IdentityProviderCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("identityProviders"), getClient(), null);
    }

    /**
     * Gets a request builder for the IdentityProvider item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.IdentityProviderWithReferenceRequestBuilder identityProviders(@Nonnull final String id) {
        return new com.microsoft.graph.requests.IdentityProviderWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("identityProviders") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UserFlowLanguageConfiguration collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UserFlowLanguageConfigurationCollectionRequestBuilder languages() {
        return new com.microsoft.graph.requests.UserFlowLanguageConfigurationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("languages"), getClient(), null);
    }

    /**
     * Gets a request builder for the UserFlowLanguageConfiguration item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UserFlowLanguageConfigurationRequestBuilder languages(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UserFlowLanguageConfigurationRequestBuilder(getRequestUrlWithAdditionalSegment("languages") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the IdentityUserFlowAttributeAssignment collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.IdentityUserFlowAttributeAssignmentCollectionRequestBuilder userAttributeAssignments() {
        return new com.microsoft.graph.requests.IdentityUserFlowAttributeAssignmentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("userAttributeAssignments"), getClient(), null);
    }

    /**
     * Gets a request builder for the IdentityUserFlowAttributeAssignment item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.IdentityUserFlowAttributeAssignmentRequestBuilder userAttributeAssignments(@Nonnull final String id) {
        return new com.microsoft.graph.requests.IdentityUserFlowAttributeAssignmentRequestBuilder(getRequestUrlWithAdditionalSegment("userAttributeAssignments") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the IdentityProviderBase collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.IdentityProviderBaseCollectionWithReferencesRequestBuilder userFlowIdentityProviders() {
        return new com.microsoft.graph.requests.IdentityProviderBaseCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("userFlowIdentityProviders"), getClient(), null);
    }

    /**
     * Gets a request builder for the IdentityProviderBase item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.IdentityProviderBaseWithReferenceRequestBuilder userFlowIdentityProviders(@Nonnull final String id) {
        return new com.microsoft.graph.requests.IdentityProviderBaseWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("userFlowIdentityProviders") + "/" + id, getClient(), null);
    }
}
