// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PlannerGroup;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Planner Group Request.
 */
public class PlannerGroupRequest extends BaseRequest<PlannerGroup> {
	
    /**
     * The request for the PlannerGroup
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PlannerGroupRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PlannerGroup.class);
    }

    /**
     * Gets the PlannerGroup from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PlannerGroup> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PlannerGroup from the service
     *
     * @return the PlannerGroup from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PlannerGroup get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PlannerGroup> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PlannerGroup delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PlannerGroup with a source
     *
     * @param sourcePlannerGroup the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PlannerGroup> patchAsync(@Nonnull final PlannerGroup sourcePlannerGroup) {
        return sendAsync(HttpMethod.PATCH, sourcePlannerGroup);
    }

    /**
     * Patches this PlannerGroup with a source
     *
     * @param sourcePlannerGroup the source object with updates
     * @return the updated PlannerGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PlannerGroup patch(@Nonnull final PlannerGroup sourcePlannerGroup) throws ClientException {
        return send(HttpMethod.PATCH, sourcePlannerGroup);
    }

    /**
     * Creates a PlannerGroup with a new object
     *
     * @param newPlannerGroup the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PlannerGroup> postAsync(@Nonnull final PlannerGroup newPlannerGroup) {
        return sendAsync(HttpMethod.POST, newPlannerGroup);
    }

    /**
     * Creates a PlannerGroup with a new object
     *
     * @param newPlannerGroup the new object to create
     * @return the created PlannerGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PlannerGroup post(@Nonnull final PlannerGroup newPlannerGroup) throws ClientException {
        return send(HttpMethod.POST, newPlannerGroup);
    }

    /**
     * Creates a PlannerGroup with a new object
     *
     * @param newPlannerGroup the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PlannerGroup> putAsync(@Nonnull final PlannerGroup newPlannerGroup) {
        return sendAsync(HttpMethod.PUT, newPlannerGroup);
    }

    /**
     * Creates a PlannerGroup with a new object
     *
     * @param newPlannerGroup the object to create/update
     * @return the created PlannerGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PlannerGroup put(@Nonnull final PlannerGroup newPlannerGroup) throws ClientException {
        return send(HttpMethod.PUT, newPlannerGroup);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PlannerGroupRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PlannerGroupRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

