// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoverySearch;
import com.microsoft.graph.security.models.PurgeType;
import com.microsoft.graph.security.models.PurgeAreas;
import java.util.EnumSet;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Search Request.
 */
public class EdiscoverySearchRequest extends BaseRequest<EdiscoverySearch> {
	
    /**
     * The request for the EdiscoverySearch
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoverySearchRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EdiscoverySearch.class);
    }

    /**
     * Gets the EdiscoverySearch from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoverySearch> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EdiscoverySearch from the service
     *
     * @return the EdiscoverySearch from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoverySearch get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoverySearch> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EdiscoverySearch delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EdiscoverySearch with a source
     *
     * @param sourceEdiscoverySearch the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoverySearch> patchAsync(@Nonnull final EdiscoverySearch sourceEdiscoverySearch) {
        return sendAsync(HttpMethod.PATCH, sourceEdiscoverySearch);
    }

    /**
     * Patches this EdiscoverySearch with a source
     *
     * @param sourceEdiscoverySearch the source object with updates
     * @return the updated EdiscoverySearch
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoverySearch patch(@Nonnull final EdiscoverySearch sourceEdiscoverySearch) throws ClientException {
        return send(HttpMethod.PATCH, sourceEdiscoverySearch);
    }

    /**
     * Creates a EdiscoverySearch with a new object
     *
     * @param newEdiscoverySearch the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoverySearch> postAsync(@Nonnull final EdiscoverySearch newEdiscoverySearch) {
        return sendAsync(HttpMethod.POST, newEdiscoverySearch);
    }

    /**
     * Creates a EdiscoverySearch with a new object
     *
     * @param newEdiscoverySearch the new object to create
     * @return the created EdiscoverySearch
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoverySearch post(@Nonnull final EdiscoverySearch newEdiscoverySearch) throws ClientException {
        return send(HttpMethod.POST, newEdiscoverySearch);
    }

    /**
     * Creates a EdiscoverySearch with a new object
     *
     * @param newEdiscoverySearch the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoverySearch> putAsync(@Nonnull final EdiscoverySearch newEdiscoverySearch) {
        return sendAsync(HttpMethod.PUT, newEdiscoverySearch);
    }

    /**
     * Creates a EdiscoverySearch with a new object
     *
     * @param newEdiscoverySearch the object to create/update
     * @return the created EdiscoverySearch
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoverySearch put(@Nonnull final EdiscoverySearch newEdiscoverySearch) throws ClientException {
        return send(HttpMethod.PUT, newEdiscoverySearch);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoverySearchRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoverySearchRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

