// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.EmailSender;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Analyzed Message Evidence.
 */
public class AnalyzedMessageEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Anti Spam Direction.
     * Direction of the email relative to your network. The possible values are: inbound, outbound or intraorg.
     */
    @SerializedName(value = "antiSpamDirection", alternate = {"AntiSpamDirection"})
    @Expose
	@Nullable
    public String antiSpamDirection;

    /**
     * The Attachments Count.
     * Number of attachments in the email.
     */
    @SerializedName(value = "attachmentsCount", alternate = {"AttachmentsCount"})
    @Expose
	@Nullable
    public Long attachmentsCount;

    /**
     * The Delivery Action.
     * Delivery action of the email. The possible values are: delivered, deliveredAsSpam, junked, blocked, or replaced.
     */
    @SerializedName(value = "deliveryAction", alternate = {"DeliveryAction"})
    @Expose
	@Nullable
    public String deliveryAction;

    /**
     * The Delivery Location.
     * Location where the email was delivered. The possible values are: inbox, external, junkFolder, quarantine, failed, dropped, deletedFolder or forwarded.
     */
    @SerializedName(value = "deliveryLocation", alternate = {"DeliveryLocation"})
    @Expose
	@Nullable
    public String deliveryLocation;

    /**
     * The Internet Message Id.
     * Public-facing identifier for the email that is set by the sending email system.
     */
    @SerializedName(value = "internetMessageId", alternate = {"InternetMessageId"})
    @Expose
	@Nullable
    public String internetMessageId;

    /**
     * The Language.
     * Detected language of the email content.
     */
    @SerializedName(value = "language", alternate = {"Language"})
    @Expose
	@Nullable
    public String language;

    /**
     * The Network Message Id.
     * Unique identifier for the email, generated by Microsoft 365.
     */
    @SerializedName(value = "networkMessageId", alternate = {"NetworkMessageId"})
    @Expose
	@Nullable
    public String networkMessageId;

    /**
     * The P1Sender.
     * The P1 sender.
     */
    @SerializedName(value = "p1Sender", alternate = {"P1Sender"})
    @Expose
	@Nullable
    public EmailSender p1Sender;

    /**
     * The P2Sender.
     * The P2 sender.
     */
    @SerializedName(value = "p2Sender", alternate = {"P2Sender"})
    @Expose
	@Nullable
    public EmailSender p2Sender;

    /**
     * The Received Date Time.
     * Date and time when the email was received.
     */
    @SerializedName(value = "receivedDateTime", alternate = {"ReceivedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime receivedDateTime;

    /**
     * The Recipient Email Address.
     * Email address of the recipient, or email address of the recipient after distribution list expansion.
     */
    @SerializedName(value = "recipientEmailAddress", alternate = {"RecipientEmailAddress"})
    @Expose
	@Nullable
    public String recipientEmailAddress;

    /**
     * The Sender Ip.
     * IP address of the last detected mail server that relayed the message.
     */
    @SerializedName(value = "senderIp", alternate = {"SenderIp"})
    @Expose
	@Nullable
    public String senderIp;

    /**
     * The Subject.
     * Subject of the email.
     */
    @SerializedName(value = "subject", alternate = {"Subject"})
    @Expose
	@Nullable
    public String subject;

    /**
     * The Threat Detection Methods.
     * Collection of methods used to detect malware, phishing, or other threats found in the email.
     */
    @SerializedName(value = "threatDetectionMethods", alternate = {"ThreatDetectionMethods"})
    @Expose
	@Nullable
    public java.util.List<String> threatDetectionMethods;

    /**
     * The Threats.
     * Collection of detection names for malware or other threats found.
     */
    @SerializedName(value = "threats", alternate = {"Threats"})
    @Expose
	@Nullable
    public java.util.List<String> threats;

    /**
     * The Url Count.
     * Number of embedded URLs in the email.
     */
    @SerializedName(value = "urlCount", alternate = {"UrlCount"})
    @Expose
	@Nullable
    public Long urlCount;

    /**
     * The Urls.
     * Collection of the URLs contained in this email.
     */
    @SerializedName(value = "urls", alternate = {"Urls"})
    @Expose
	@Nullable
    public java.util.List<String> urls;

    /**
     * The Urn.
     * Uniform resource name (URN) of the automated investigation where the cluster was identified.
     */
    @SerializedName(value = "urn", alternate = {"Urn"})
    @Expose
	@Nullable
    public String urn;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
