// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ServiceAnnouncementBase;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Announcement Base Request.
 */
public class ServiceAnnouncementBaseRequest extends BaseRequest<ServiceAnnouncementBase> {
	
    /**
     * The request for the ServiceAnnouncementBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public ServiceAnnouncementBaseRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends ServiceAnnouncementBase> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the ServiceAnnouncementBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ServiceAnnouncementBaseRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServiceAnnouncementBase.class);
    }

    /**
     * Gets the ServiceAnnouncementBase from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceAnnouncementBase> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ServiceAnnouncementBase from the service
     *
     * @return the ServiceAnnouncementBase from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceAnnouncementBase get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceAnnouncementBase> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ServiceAnnouncementBase delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ServiceAnnouncementBase with a source
     *
     * @param sourceServiceAnnouncementBase the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceAnnouncementBase> patchAsync(@Nonnull final ServiceAnnouncementBase sourceServiceAnnouncementBase) {
        return sendAsync(HttpMethod.PATCH, sourceServiceAnnouncementBase);
    }

    /**
     * Patches this ServiceAnnouncementBase with a source
     *
     * @param sourceServiceAnnouncementBase the source object with updates
     * @return the updated ServiceAnnouncementBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceAnnouncementBase patch(@Nonnull final ServiceAnnouncementBase sourceServiceAnnouncementBase) throws ClientException {
        return send(HttpMethod.PATCH, sourceServiceAnnouncementBase);
    }

    /**
     * Creates a ServiceAnnouncementBase with a new object
     *
     * @param newServiceAnnouncementBase the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceAnnouncementBase> postAsync(@Nonnull final ServiceAnnouncementBase newServiceAnnouncementBase) {
        return sendAsync(HttpMethod.POST, newServiceAnnouncementBase);
    }

    /**
     * Creates a ServiceAnnouncementBase with a new object
     *
     * @param newServiceAnnouncementBase the new object to create
     * @return the created ServiceAnnouncementBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceAnnouncementBase post(@Nonnull final ServiceAnnouncementBase newServiceAnnouncementBase) throws ClientException {
        return send(HttpMethod.POST, newServiceAnnouncementBase);
    }

    /**
     * Creates a ServiceAnnouncementBase with a new object
     *
     * @param newServiceAnnouncementBase the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceAnnouncementBase> putAsync(@Nonnull final ServiceAnnouncementBase newServiceAnnouncementBase) {
        return sendAsync(HttpMethod.PUT, newServiceAnnouncementBase);
    }

    /**
     * Creates a ServiceAnnouncementBase with a new object
     *
     * @param newServiceAnnouncementBase the object to create/update
     * @return the created ServiceAnnouncementBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceAnnouncementBase put(@Nonnull final ServiceAnnouncementBase newServiceAnnouncementBase) throws ClientException {
        return send(HttpMethod.PUT, newServiceAnnouncementBase);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ServiceAnnouncementBaseRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ServiceAnnouncementBaseRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

