// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AuthenticationMethodModeDetail;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Method Mode Detail Request.
 */
public class AuthenticationMethodModeDetailRequest extends BaseRequest<AuthenticationMethodModeDetail> {
	
    /**
     * The request for the AuthenticationMethodModeDetail
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationMethodModeDetailRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationMethodModeDetail.class);
    }

    /**
     * Gets the AuthenticationMethodModeDetail from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodModeDetail> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AuthenticationMethodModeDetail from the service
     *
     * @return the AuthenticationMethodModeDetail from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethodModeDetail get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodModeDetail> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AuthenticationMethodModeDetail delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AuthenticationMethodModeDetail with a source
     *
     * @param sourceAuthenticationMethodModeDetail the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodModeDetail> patchAsync(@Nonnull final AuthenticationMethodModeDetail sourceAuthenticationMethodModeDetail) {
        return sendAsync(HttpMethod.PATCH, sourceAuthenticationMethodModeDetail);
    }

    /**
     * Patches this AuthenticationMethodModeDetail with a source
     *
     * @param sourceAuthenticationMethodModeDetail the source object with updates
     * @return the updated AuthenticationMethodModeDetail
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethodModeDetail patch(@Nonnull final AuthenticationMethodModeDetail sourceAuthenticationMethodModeDetail) throws ClientException {
        return send(HttpMethod.PATCH, sourceAuthenticationMethodModeDetail);
    }

    /**
     * Creates a AuthenticationMethodModeDetail with a new object
     *
     * @param newAuthenticationMethodModeDetail the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodModeDetail> postAsync(@Nonnull final AuthenticationMethodModeDetail newAuthenticationMethodModeDetail) {
        return sendAsync(HttpMethod.POST, newAuthenticationMethodModeDetail);
    }

    /**
     * Creates a AuthenticationMethodModeDetail with a new object
     *
     * @param newAuthenticationMethodModeDetail the new object to create
     * @return the created AuthenticationMethodModeDetail
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethodModeDetail post(@Nonnull final AuthenticationMethodModeDetail newAuthenticationMethodModeDetail) throws ClientException {
        return send(HttpMethod.POST, newAuthenticationMethodModeDetail);
    }

    /**
     * Creates a AuthenticationMethodModeDetail with a new object
     *
     * @param newAuthenticationMethodModeDetail the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodModeDetail> putAsync(@Nonnull final AuthenticationMethodModeDetail newAuthenticationMethodModeDetail) {
        return sendAsync(HttpMethod.PUT, newAuthenticationMethodModeDetail);
    }

    /**
     * Creates a AuthenticationMethodModeDetail with a new object
     *
     * @param newAuthenticationMethodModeDetail the object to create/update
     * @return the created AuthenticationMethodModeDetail
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethodModeDetail put(@Nonnull final AuthenticationMethodModeDetail newAuthenticationMethodModeDetail) throws ClientException {
        return send(HttpMethod.PUT, newAuthenticationMethodModeDetail);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationMethodModeDetailRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationMethodModeDetailRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

