// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.TrainingStatus;
import com.microsoft.graph.models.UserTrainingContentEventInfo;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Training Event Info.
 */
public class UserTrainingEventInfo implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Display Name.
     * Display name of the training.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Latest Training Status.
     * Latest status of the training assigned to the user. Possible values are: unknown, assigned, inProgress, completed, overdue, unknownFutureValue.
     */
    @SerializedName(value = "latestTrainingStatus", alternate = {"LatestTrainingStatus"})
    @Expose
	@Nullable
    public TrainingStatus latestTrainingStatus;

    /**
     * The Training Assigned Properties.
     * Event details of the training when it was assigned to the user.
     */
    @SerializedName(value = "trainingAssignedProperties", alternate = {"TrainingAssignedProperties"})
    @Expose
	@Nullable
    public UserTrainingContentEventInfo trainingAssignedProperties;

    /**
     * The Training Completed Properties.
     * Event details of the training when it was completed by the user.
     */
    @SerializedName(value = "trainingCompletedProperties", alternate = {"TrainingCompletedProperties"})
    @Expose
	@Nullable
    public UserTrainingContentEventInfo trainingCompletedProperties;

    /**
     * The Training Updated Properties.
     * Event details of the training when it was updated/in-progress by the user.
     */
    @SerializedName(value = "trainingUpdatedProperties", alternate = {"TrainingUpdatedProperties"})
    @Expose
	@Nullable
    public UserTrainingContentEventInfo trainingUpdatedProperties;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
