// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoverySearch;
import com.microsoft.graph.security.models.DataSource;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.DataSourceCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.DataSourceCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.DataSourceCollectionResponse;
import com.microsoft.graph.security.models.DataSource;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Data Source Collection With References Page.
 */
public class DataSourceCollectionWithReferencesPage extends BaseCollectionPage<DataSource, DataSourceCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for DataSource
     *
     * @param response the serialized DataSourceCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public DataSourceCollectionWithReferencesPage(@Nonnull final DataSourceCollectionResponse response, @Nullable final DataSourceCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for DataSource
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public DataSourceCollectionWithReferencesPage(@Nonnull final java.util.List<DataSource> pageContents, @Nullable final DataSourceCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
