// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.RiskyUserConfirmCompromisedRequest;
import com.microsoft.graph.models.RiskyUser;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.RiskyUserConfirmCompromisedParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Risky User Confirm Compromised Request Builder.
 */
public class RiskyUserConfirmCompromisedRequestBuilder extends BaseActionRequestBuilder<RiskyUser> {

    /**
     * The request builder for this RiskyUserConfirmCompromised
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RiskyUserConfirmCompromisedRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private RiskyUserConfirmCompromisedParameterSet body;
    /**
     * The request builder for this RiskyUserConfirmCompromised
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public RiskyUserConfirmCompromisedRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final RiskyUserConfirmCompromisedParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the RiskyUserConfirmCompromisedRequest
     *
     * @param requestOptions the options for the request
     * @return the RiskyUserConfirmCompromisedRequest instance
     */
    @Nonnull
    public RiskyUserConfirmCompromisedRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the RiskyUserConfirmCompromisedRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the RiskyUserConfirmCompromisedRequest instance
     */
    @Nonnull
    public RiskyUserConfirmCompromisedRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final RiskyUserConfirmCompromisedRequest request = new RiskyUserConfirmCompromisedRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
