// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AuthenticationStrengthUsage;
import com.microsoft.graph.models.ConditionalAccessPolicy;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ConditionalAccessPolicyCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ConditionalAccessPolicyCollectionWithReferencesPage;
import com.microsoft.graph.requests.ConditionalAccessPolicyCollectionResponse;
import com.microsoft.graph.models.ConditionalAccessPolicy;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conditional Access Policy Collection With References Page.
 */
public class ConditionalAccessPolicyCollectionWithReferencesPage extends BaseCollectionPage<ConditionalAccessPolicy, ConditionalAccessPolicyCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for ConditionalAccessPolicy
     *
     * @param response the serialized ConditionalAccessPolicyCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public ConditionalAccessPolicyCollectionWithReferencesPage(@Nonnull final ConditionalAccessPolicyCollectionResponse response, @Nullable final ConditionalAccessPolicyCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for ConditionalAccessPolicy
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public ConditionalAccessPolicyCollectionWithReferencesPage(@Nonnull final java.util.List<ConditionalAccessPolicy> pageContents, @Nullable final ConditionalAccessPolicyCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
