// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.EducationResource;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Teams App Resource.
 */
public class EducationTeamsAppResource extends EducationResource implements IJsonBackedObject {


    /**
     * The App Icon Web Url.
     * URL that points to the icon of the app.
     */
    @SerializedName(value = "appIconWebUrl", alternate = {"AppIconWebUrl"})
    @Expose
	@Nullable
    public String appIconWebUrl;

    /**
     * The App Id.
     * Teams app ID of the application.
     */
    @SerializedName(value = "appId", alternate = {"AppId"})
    @Expose
	@Nullable
    public String appId;

    /**
     * The Teams Embedded Content Url.
     * URL for the app resource that will be opened by Teams.
     */
    @SerializedName(value = "teamsEmbeddedContentUrl", alternate = {"TeamsEmbeddedContentUrl"})
    @Expose
	@Nullable
    public String teamsEmbeddedContentUrl;

    /**
     * The Web Url.
     * URL for the app resource that can be opened in the browser.
     */
    @SerializedName(value = "webUrl", alternate = {"WebUrl"})
    @Expose
	@Nullable
    public String webUrl;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
