// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AccessPackageAnswerChoice;
import com.microsoft.graph.models.AccessPackageQuestion;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Multiple Choice Question.
 */
public class AccessPackageMultipleChoiceQuestion extends AccessPackageQuestion implements IJsonBackedObject {


    /**
     * The Choices.
     * List of answer choices.
     */
    @SerializedName(value = "choices", alternate = {"Choices"})
    @Expose
	@Nullable
    public java.util.List<AccessPackageAnswerChoice> choices;

    /**
     * The Is Multiple Selection Allowed.
     * Indicates whether requestor can select multiple choices as their answer.
     */
    @SerializedName(value = "isMultipleSelectionAllowed", alternate = {"IsMultipleSelectionAllowed"})
    @Expose
	@Nullable
    public Boolean isMultipleSelectionAllowed;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
