// Template Source: BaseMethodCollectionPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Device;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.DeltaCollectionPage;
import com.microsoft.graph.requests.DeviceDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.DeviceDeltaCollectionPage;
import com.microsoft.graph.requests.DeviceDeltaCollectionResponse;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Delta Collection Page.
 */
public class DeviceDeltaCollectionPage extends DeltaCollectionPage<Device, DeviceDeltaCollectionRequestBuilder> {

    /**
     * A collection page for Device.
     *
     * @param response The serialized DeviceDeltaCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public DeviceDeltaCollectionPage(@Nonnull final DeviceDeltaCollectionResponse response, @Nonnull final DeviceDeltaCollectionRequestBuilder builder) {
       super(response, builder);
    }

	/**
     * Creates the collection page for DeviceDelta
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public DeviceDeltaCollectionPage(@Nonnull final java.util.List<Device> pageContents, @Nullable final DeviceDeltaCollectionRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
