// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.PrintJobConfiguration;
import com.microsoft.graph.models.PrintJob;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Job Redirect Parameter Set.
 */
public class PrintJobRedirectParameterSet {
    /**
     * The destination Printer Id.
     * 
     */
    @SerializedName(value = "destinationPrinterId", alternate = {"DestinationPrinterId"})
    @Expose
	@Nullable
    public String destinationPrinterId;

    /**
     * The configuration.
     * 
     */
    @SerializedName(value = "configuration", alternate = {"Configuration"})
    @Expose
	@Nullable
    public PrintJobConfiguration configuration;


    /**
     * Instiaciates a new PrintJobRedirectParameterSet
     */
    public PrintJobRedirectParameterSet() {}
    /**
     * Instiaciates a new PrintJobRedirectParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected PrintJobRedirectParameterSet(@Nonnull final PrintJobRedirectParameterSetBuilder builder) {
        this.destinationPrinterId = builder.destinationPrinterId;
        this.configuration = builder.configuration;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static PrintJobRedirectParameterSetBuilder newBuilder() {
        return new PrintJobRedirectParameterSetBuilder();
    }
    /**
     * Fluent builder for the PrintJobRedirectParameterSet
     */
    public static final class PrintJobRedirectParameterSetBuilder {
        /**
         * The destinationPrinterId parameter value
         */
        @Nullable
        protected String destinationPrinterId;
        /**
         * Sets the DestinationPrinterId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PrintJobRedirectParameterSetBuilder withDestinationPrinterId(@Nullable final String val) {
            this.destinationPrinterId = val;
            return this;
        }
        /**
         * The configuration parameter value
         */
        @Nullable
        protected PrintJobConfiguration configuration;
        /**
         * Sets the Configuration
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PrintJobRedirectParameterSetBuilder withConfiguration(@Nullable final PrintJobConfiguration val) {
            this.configuration = val;
            return this;
        }
        /**
         * Instanciates a new PrintJobRedirectParameterSetBuilder
         */
        @Nullable
        protected PrintJobRedirectParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public PrintJobRedirectParameterSet build() {
            return new PrintJobRedirectParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.destinationPrinterId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("destinationPrinterId", destinationPrinterId));
        }
        if(this.configuration != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("configuration", configuration));
        }
        return result;
    }
}
