/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DriveItemCollectionPage;
import com.microsoft.graph.requests.DriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemCollectionResponse;
import com.microsoft.graph.requests.DriveItemRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DriveItemCollectionRequest
extends BaseEntityCollectionRequest<DriveItem, DriveItemCollectionResponse, DriveItemCollectionPage> {
    public DriveItemCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveItemCollectionResponse.class, DriveItemCollectionPage.class, DriveItemCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<DriveItem> postAsync(@Nonnull DriveItem newDriveItem) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DriveItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newDriveItem);
    }

    @Nonnull
    public DriveItem post(@Nonnull DriveItem newDriveItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DriveItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDriveItem);
    }

    @Nonnull
    public DriveItemCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public DriveItemCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public DriveItemCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public DriveItemCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DriveItemCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public DriveItemCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public DriveItemCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public DriveItemCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public DriveItemCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

