/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Shift;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ShiftCollectionPage;
import com.microsoft.graph.requests.ShiftCollectionRequestBuilder;
import com.microsoft.graph.requests.ShiftCollectionResponse;
import com.microsoft.graph.requests.ShiftRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ShiftCollectionRequest
extends BaseEntityCollectionRequest<Shift, ShiftCollectionResponse, ShiftCollectionPage> {
    public ShiftCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ShiftCollectionResponse.class, ShiftCollectionPage.class, ShiftCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Shift> postAsync(@Nonnull Shift newShift) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ShiftRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newShift);
    }

    @Nonnull
    public Shift post(@Nonnull Shift newShift) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ShiftRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newShift);
    }

    @Nonnull
    public ShiftCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ShiftCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ShiftCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ShiftCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ShiftCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ShiftCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ShiftCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ShiftCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ShiftCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

