/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.OAuth2PermissionGrant;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.OAuth2PermissionGrantCollectionPage;
import com.microsoft.graph.requests.OAuth2PermissionGrantCollectionRequestBuilder;
import com.microsoft.graph.requests.OAuth2PermissionGrantCollectionResponse;
import com.microsoft.graph.requests.OAuth2PermissionGrantRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OAuth2PermissionGrantCollectionRequest
extends BaseEntityCollectionRequest<OAuth2PermissionGrant, OAuth2PermissionGrantCollectionResponse, OAuth2PermissionGrantCollectionPage> {
    public OAuth2PermissionGrantCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OAuth2PermissionGrantCollectionResponse.class, OAuth2PermissionGrantCollectionPage.class, OAuth2PermissionGrantCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<OAuth2PermissionGrant> postAsync(@Nonnull OAuth2PermissionGrant newOAuth2PermissionGrant) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OAuth2PermissionGrantRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newOAuth2PermissionGrant);
    }

    @Nonnull
    public OAuth2PermissionGrant post(@Nonnull OAuth2PermissionGrant newOAuth2PermissionGrant) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OAuth2PermissionGrantRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOAuth2PermissionGrant);
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

