// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TeamInfo;
import com.microsoft.graph.requests.TeamWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Team Info Request.
 */
public class TeamInfoRequest extends BaseRequest<TeamInfo> {
	
    /**
     * The request for the TeamInfo
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public TeamInfoRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends TeamInfo> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the TeamInfo
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamInfoRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamInfo.class);
    }

    /**
     * Gets the TeamInfo from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamInfo> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TeamInfo from the service
     *
     * @return the TeamInfo from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamInfo get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamInfo> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TeamInfo delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TeamInfo with a source
     *
     * @param sourceTeamInfo the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamInfo> patchAsync(@Nonnull final TeamInfo sourceTeamInfo) {
        return sendAsync(HttpMethod.PATCH, sourceTeamInfo);
    }

    /**
     * Patches this TeamInfo with a source
     *
     * @param sourceTeamInfo the source object with updates
     * @return the updated TeamInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamInfo patch(@Nonnull final TeamInfo sourceTeamInfo) throws ClientException {
        return send(HttpMethod.PATCH, sourceTeamInfo);
    }

    /**
     * Creates a TeamInfo with a new object
     *
     * @param newTeamInfo the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamInfo> postAsync(@Nonnull final TeamInfo newTeamInfo) {
        return sendAsync(HttpMethod.POST, newTeamInfo);
    }

    /**
     * Creates a TeamInfo with a new object
     *
     * @param newTeamInfo the new object to create
     * @return the created TeamInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamInfo post(@Nonnull final TeamInfo newTeamInfo) throws ClientException {
        return send(HttpMethod.POST, newTeamInfo);
    }

    /**
     * Creates a TeamInfo with a new object
     *
     * @param newTeamInfo the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamInfo> putAsync(@Nonnull final TeamInfo newTeamInfo) {
        return sendAsync(HttpMethod.PUT, newTeamInfo);
    }

    /**
     * Creates a TeamInfo with a new object
     *
     * @param newTeamInfo the object to create/update
     * @return the created TeamInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamInfo put(@Nonnull final TeamInfo newTeamInfo) throws ClientException {
        return send(HttpMethod.PUT, newTeamInfo);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TeamInfoRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TeamInfoRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

