// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Invitation;
import com.microsoft.graph.requests.UserWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Invitation Request.
 */
public class InvitationRequest extends BaseRequest<Invitation> {
	
    /**
     * The request for the Invitation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public InvitationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Invitation.class);
    }

    /**
     * Gets the Invitation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Invitation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Invitation from the service
     *
     * @return the Invitation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Invitation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Invitation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Invitation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Invitation with a source
     *
     * @param sourceInvitation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Invitation> patchAsync(@Nonnull final Invitation sourceInvitation) {
        return sendAsync(HttpMethod.PATCH, sourceInvitation);
    }

    /**
     * Patches this Invitation with a source
     *
     * @param sourceInvitation the source object with updates
     * @return the updated Invitation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Invitation patch(@Nonnull final Invitation sourceInvitation) throws ClientException {
        return send(HttpMethod.PATCH, sourceInvitation);
    }

    /**
     * Creates a Invitation with a new object
     *
     * @param newInvitation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Invitation> postAsync(@Nonnull final Invitation newInvitation) {
        return sendAsync(HttpMethod.POST, newInvitation);
    }

    /**
     * Creates a Invitation with a new object
     *
     * @param newInvitation the new object to create
     * @return the created Invitation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Invitation post(@Nonnull final Invitation newInvitation) throws ClientException {
        return send(HttpMethod.POST, newInvitation);
    }

    /**
     * Creates a Invitation with a new object
     *
     * @param newInvitation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Invitation> putAsync(@Nonnull final Invitation newInvitation) {
        return sendAsync(HttpMethod.PUT, newInvitation);
    }

    /**
     * Creates a Invitation with a new object
     *
     * @param newInvitation the object to create/update
     * @return the created Invitation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Invitation put(@Nonnull final Invitation newInvitation) throws ClientException {
        return send(HttpMethod.PUT, newInvitation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public InvitationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public InvitationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

