// Template Source: BaseEntityWithReferenceRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ContentType;
import com.microsoft.graph.models.ItemReference;
import com.microsoft.graph.requests.ContentTypeWithReferenceRequestBuilder;
import com.microsoft.graph.requests.ContentTypeCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ColumnLinkCollectionRequestBuilder;
import com.microsoft.graph.requests.ColumnLinkRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionWithReferenceRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.BaseWithReferenceRequestBuilder;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Content Type With Reference Request Builder.
 */
public class ContentTypeWithReferenceRequestBuilder extends BaseWithReferenceRequestBuilder<ContentType, ContentTypeWithReferenceRequest, ContentTypeReferenceRequestBuilder> {

    /**
     * The request builder for the ContentType
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ContentTypeWithReferenceRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContentTypeWithReferenceRequest.class, ContentTypeReferenceRequestBuilder.class);
    }
}
