// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessReviewScheduleDefinition;
import com.microsoft.graph.models.AccessReviewScheduleDefinitionFilterByCurrentUserOptions;
import com.microsoft.graph.requests.AccessReviewInstanceCollectionRequestBuilder;
import com.microsoft.graph.requests.AccessReviewInstanceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review Schedule Definition Request Builder.
 */
public class AccessReviewScheduleDefinitionRequestBuilder extends BaseRequestBuilder<AccessReviewScheduleDefinition> {

    /**
     * The request builder for the AccessReviewScheduleDefinition
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessReviewScheduleDefinitionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AccessReviewScheduleDefinitionRequest instance
     */
    @Nonnull
    public AccessReviewScheduleDefinitionRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the AccessReviewScheduleDefinitionRequest instance
     */
    @Nonnull
    public AccessReviewScheduleDefinitionRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.AccessReviewScheduleDefinitionRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the AccessReviewInstance collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public AccessReviewInstanceCollectionRequestBuilder instances() {
        return new AccessReviewInstanceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("instances"), getClient(), null);
    }

    /**
     * Gets a request builder for the AccessReviewInstance item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public AccessReviewInstanceRequestBuilder instances(@Nonnull final String id) {
        return new AccessReviewInstanceRequestBuilder(getRequestUrlWithAdditionalSegment("instances") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public AccessReviewScheduleDefinitionStopRequestBuilder stop() {
        return new AccessReviewScheduleDefinitionStopRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.stop"), getClient(), null);
    }
}
