// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ConditionalAccessRoot;
import com.microsoft.graph.requests.NamedLocationCollectionRequestBuilder;
import com.microsoft.graph.requests.NamedLocationRequestBuilder;
import com.microsoft.graph.requests.ConditionalAccessPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.ConditionalAccessPolicyRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conditional Access Root Request.
 */
public class ConditionalAccessRootRequest extends BaseRequest<ConditionalAccessRoot> {
	
    /**
     * The request for the ConditionalAccessRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ConditionalAccessRootRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConditionalAccessRoot.class);
    }

    /**
     * Gets the ConditionalAccessRoot from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConditionalAccessRoot> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ConditionalAccessRoot from the service
     *
     * @return the ConditionalAccessRoot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ConditionalAccessRoot get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConditionalAccessRoot> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ConditionalAccessRoot delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ConditionalAccessRoot with a source
     *
     * @param sourceConditionalAccessRoot the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConditionalAccessRoot> patchAsync(@Nonnull final ConditionalAccessRoot sourceConditionalAccessRoot) {
        return sendAsync(HttpMethod.PATCH, sourceConditionalAccessRoot);
    }

    /**
     * Patches this ConditionalAccessRoot with a source
     *
     * @param sourceConditionalAccessRoot the source object with updates
     * @return the updated ConditionalAccessRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ConditionalAccessRoot patch(@Nonnull final ConditionalAccessRoot sourceConditionalAccessRoot) throws ClientException {
        return send(HttpMethod.PATCH, sourceConditionalAccessRoot);
    }

    /**
     * Creates a ConditionalAccessRoot with a new object
     *
     * @param newConditionalAccessRoot the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConditionalAccessRoot> postAsync(@Nonnull final ConditionalAccessRoot newConditionalAccessRoot) {
        return sendAsync(HttpMethod.POST, newConditionalAccessRoot);
    }

    /**
     * Creates a ConditionalAccessRoot with a new object
     *
     * @param newConditionalAccessRoot the new object to create
     * @return the created ConditionalAccessRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ConditionalAccessRoot post(@Nonnull final ConditionalAccessRoot newConditionalAccessRoot) throws ClientException {
        return send(HttpMethod.POST, newConditionalAccessRoot);
    }

    /**
     * Creates a ConditionalAccessRoot with a new object
     *
     * @param newConditionalAccessRoot the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConditionalAccessRoot> putAsync(@Nonnull final ConditionalAccessRoot newConditionalAccessRoot) {
        return sendAsync(HttpMethod.PUT, newConditionalAccessRoot);
    }

    /**
     * Creates a ConditionalAccessRoot with a new object
     *
     * @param newConditionalAccessRoot the object to create/update
     * @return the created ConditionalAccessRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ConditionalAccessRoot put(@Nonnull final ConditionalAccessRoot newConditionalAccessRoot) throws ClientException {
        return send(HttpMethod.PUT, newConditionalAccessRoot);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ConditionalAccessRootRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ConditionalAccessRootRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

