// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UsedInsight;
import com.microsoft.graph.requests.EntityWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Used Insight Request.
 */
public class UsedInsightRequest extends BaseRequest<UsedInsight> {
	
    /**
     * The request for the UsedInsight
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UsedInsightRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UsedInsight.class);
    }

    /**
     * Gets the UsedInsight from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UsedInsight> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UsedInsight from the service
     *
     * @return the UsedInsight from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UsedInsight get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UsedInsight> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UsedInsight delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UsedInsight with a source
     *
     * @param sourceUsedInsight the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UsedInsight> patchAsync(@Nonnull final UsedInsight sourceUsedInsight) {
        return sendAsync(HttpMethod.PATCH, sourceUsedInsight);
    }

    /**
     * Patches this UsedInsight with a source
     *
     * @param sourceUsedInsight the source object with updates
     * @return the updated UsedInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UsedInsight patch(@Nonnull final UsedInsight sourceUsedInsight) throws ClientException {
        return send(HttpMethod.PATCH, sourceUsedInsight);
    }

    /**
     * Creates a UsedInsight with a new object
     *
     * @param newUsedInsight the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UsedInsight> postAsync(@Nonnull final UsedInsight newUsedInsight) {
        return sendAsync(HttpMethod.POST, newUsedInsight);
    }

    /**
     * Creates a UsedInsight with a new object
     *
     * @param newUsedInsight the new object to create
     * @return the created UsedInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UsedInsight post(@Nonnull final UsedInsight newUsedInsight) throws ClientException {
        return send(HttpMethod.POST, newUsedInsight);
    }

    /**
     * Creates a UsedInsight with a new object
     *
     * @param newUsedInsight the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UsedInsight> putAsync(@Nonnull final UsedInsight newUsedInsight) {
        return sendAsync(HttpMethod.PUT, newUsedInsight);
    }

    /**
     * Creates a UsedInsight with a new object
     *
     * @param newUsedInsight the object to create/update
     * @return the created UsedInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UsedInsight put(@Nonnull final UsedInsight newUsedInsight) throws ClientException {
        return send(HttpMethod.PUT, newUsedInsight);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UsedInsightRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UsedInsightRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

