// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.UnifiedRoleManagementPolicyRuleTargetOperations;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.requests.DirectoryObjectCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Management Policy Rule Target.
 */
public class UnifiedRoleManagementPolicyRuleTarget implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Caller.
     * The caller for the policy rule target. Allowed values are: None, Admin, EndUser.
     */
    @SerializedName(value = "caller", alternate = {"Caller"})
    @Expose
	@Nullable
    public String caller;

    /**
     * The Enforced Settings.
     * The list of settings which are enforced and cannot be overridden by child scopes. Use All for all settings.
     */
    @SerializedName(value = "enforcedSettings", alternate = {"EnforcedSettings"})
    @Expose
	@Nullable
    public java.util.List<String> enforcedSettings;

    /**
     * The Inheritable Settings.
     * The list of settings which can be inherited by child scopes. Use All for all settings.
     */
    @SerializedName(value = "inheritableSettings", alternate = {"InheritableSettings"})
    @Expose
	@Nullable
    public java.util.List<String> inheritableSettings;

    /**
     * The Level.
     * The level for the policy rule target. Allowed values are: Eligibility, Assignment.
     */
    @SerializedName(value = "level", alternate = {"Level"})
    @Expose
	@Nullable
    public String level;

    /**
     * The Operations.
     * The operations for policy rule target. Allowed values are: All, Activate, Deactivate, Assign, Update, Remove, Extend, Renew.
     */
    @SerializedName(value = "operations", alternate = {"Operations"})
    @Expose
	@Nullable
    public java.util.List<UnifiedRoleManagementPolicyRuleTargetOperations> operations;

    /**
     * The Target Objects.
     * 
     */
	@Nullable
    public DirectoryObjectCollectionPage targetObjects;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
